import { viewAllAssetCategory } from "./initAssetCategory.js";

export function initAction() {
	/*******************************************************************************************
								VALIDATE INPUT DATA SUPPLIER
	*******************************************************************************************/
	$("form[name='add-asset-category']").validate({
		// Specify validation rules
		rules: {
			asset_cateegory_name: "required",
		},
		// Specify validation error messages
		messages: {
			asset_cateegory_name: "Jenis aset harus diisi",
		},
		submitHandler: function (form) {
			var formData = new FormData(form);
			$.ajax({
				url: rootApp + "api/asset-category/add",
				type: "POST",
				data: formData,
				dataType: "json",
				contentType: false,
				processData: false,
				success: function (res) {
					$("#modal_form_add").modal("hide");
					$("form[name='add-asset-category']")[0].reset();
					pnotifySuccess(res.status, res.message);
					viewAllAssetCategory();
				},
				error: function (request, error) {
					pnotifyError("Error", JSON.stringify(request.statusText));
				},
			});
		},
	});


	/*******************************************************************************************
									ON CLICK BUTTON EDIT
	*******************************************************************************************/
	$("#table-body-asset-category").on("click", ".btn-edit", function () {
		var id = $(this).data("id");
		$.ajax({
			url: rootApp + "api/asset-category/get-by-id",
			type: "GET",
			data: {
				id: id,
			},
			dataType: "json",
			success: function (res) {
				const data = res.data[0];
				$("#modal_form_edit").modal("show");
				$("#asset_category_id").val(data.asset_category_id);
				$("#asset_category_name").val(data.asset_category_name);
				$("#is_main_category").val(data.is_main_category == 1 ? "true" : "false");
			},
			error: function (request, error) {
				// console.log("Request: " + JSON.stringify(request));
			},
		});
	});

	$("form[name='edit-asset-category']").validate({
		// Specify validation rules
		rules: {
			asset_category_name: "required",
		},
		// Specify validation error messages
		messages: {
			asset_category_name: "Masukan jenis aset",
		},
		submitHandler: function (form) {
			try {
				$.ajax({
					url: rootApp + "api/asset-category/edit",
					type: "POST",
					data: $("#edit-asset-category").serialize(),
					dataType: "json",
					success: function (res) {
						$("#modal_form_edit").modal("hide");
						pnotifySuccess(res.status, res.message);
						viewAllAssetCategory();
					},
					error: function (request, error) {
						pnotifyError('Error', JSON.stringify(request.statusText));
					},
				});
			} catch (error) {
				console.log(error);
			}
		},
	});
	

	/*******************************************************************************************
									ON CLICK BUTTON DELETE
	*******************************************************************************************/
	$("#table-body-asset-category").on("click", ".btn-delete", function () {
		var id = $(this).data("id");
		// Setup
		var notice = new PNotify({
			title: "Konfirmasi",
			text: "<p>Apakah anda yakin ingin menghapus baris ini? Anda tidak dapat mengembalikannya.</p>",
			hide: false,
			type: "warning",
			confirm: {
				confirm: true,
				buttons: [
					{
						text: "Ya, Hapus",
						addClass: "btn btn-sm btn-primary",
					},
					{
						text: "Batal",
						addClass: "btn btn-sm btn-link",
					},
				],
			},
			buttons: {
				closer: false,
				sticker: false,
			},
		});

		// On Comfirm
		notice.get().on("pnotify.confirm", function () {
			$.ajax({
				url: rootApp + "api/asset-category/delete",
				type: "POST",
				data: { id: id },
				dataType: "json",
				success: function (res) {
					pnotifySuccess(res.status, res.message);
					viewAllAssetCategory();
				},
				error: function (request, error) {
					pnotifyError("Error", JSON.stringify(request.statusText));
				},
			});
		});
	});
}
