$( document ).ready(function() {
    checkLoginAgent()
});

// $("#form-front-login").submit(function (e) {
//     e.preventDefault();
//     $.ajax({
//         url: rootApp + "api/auth/login-agen",
//         type: "POST",
//         data: $("#form-front-login").serialize(),
//         success: function (res) {
//             setCookie(appShortName+'MAIN_LOGIN_STATUS', 1, 1)
//             setCookie(appShortName+'MAIN_USER_ID', res.data.userid, 1)
//             setCookie(appShortName+'MAIN_fullname', res.data.fullname, 1)
//             setCookie(appShortName+'MAIN_level', res.data.level, 1)
//             setCookie(appShortName+'MAIN_ID_CARD', res.data.id_card, 1)
//             setCookie(appShortName+'MAIN_PHONE_NUMBER', res.data.phone_number, 1)
//             setCookie(appShortName+'MAIN_EMAIL', res.data.email, 1)
//             setCookie(appShortName+'MAIN_PHOTO', res.data.photo, 1)
//             window.location.href = rootApp;
//         },
//         error: function (request, error) {
//             alert("Nama pengguna atau password salah!")
//         },
//     });
// });

$(document).ready(function () {
    $("#form-front-login").submit(function (e) {
        e.preventDefault();
        console.log("Form #form-front-login submit event triggered");

        $.ajax({
            url: rootApp + "api/auth/login-agen",
            type: "POST",
            data: $("#form-front-login").serialize(),
            dataType: "json",
            timeout: 10000,
            success: function (res, textStatus, xhr) {
                if (res.status === 'Ok') {
                    const d = res.data;
                    setCookie(appShortName + 'MAIN_LOGIN_STATUS', 1, 1);
                    setCookie(appShortName + 'MAIN_USER_ID', d.userid, 1);
                    setCookie(appShortName + 'MAIN_fullname', d.fullname, 1);
                    setCookie(appShortName + 'MAIN_level', d.level, 1);
                    setCookie(appShortName + 'MAIN_ID_CARD', d.id_card, 1);
                    setCookie(appShortName + 'MAIN_PHONE_NUMBER', d.phone_number, 1);
                    setCookie(appShortName + 'MAIN_EMAIL', d.email, 1);
                    setCookie(appShortName + 'MAIN_PHOTO', d.photo, 1);

                    toastr.success("Login berhasil. Mengalihkan halaman...", "Sukses");
                    setTimeout(() => {
                        window.location.href = rootApp;
                    }, 1500);
                } else {
                    toastr.warning(res.message || "Gagal login.", "Peringatan");
                }
            },
            error: function (xhr, textStatus, errorThrown) {
                let message = "Terjadi kesalahan. Silakan coba lagi.";

                switch (xhr.status) {
                    case 0:
                        message = "Tidak dapat terhubung ke server. Periksa koneksi internet Anda.";
                        break;
                    case 400:
                        message = "Permintaan tidak valid (400).";
                        break;
                    case 401:
                        message = "Nama pengguna atau password salah.";
                        break;
                    case 404:
                        message = "Endpoint tidak ditemukan (404).";
                        break;
                    case 500:
                        message = "Terjadi kesalahan server (500).";
                        break;
                    case 501:
                        message = "Server tidak mendukung request (501).";
                        break;
                    default:
                        message = `Error ${xhr.status}: ${xhr.statusText}`;
                        break;
                }

                toastr.error(message, "Gagal");
            }
        });
    });
});


function checkLoginAgent(){
	//GET LEVEL AGEN LOGIN
	const levelAgen = getCookie(appShortName+'MAIN_level') != '' ? getCookie(appShortName+'MAIN_level') : '';
	if(levelAgen != '' || levelAgen == 'agen'){
		$('#login-button').html('<a href="javascript:void(0)" onclick="logoutFunction()" class="text-black"><small>Logout Akun</small></a>');
	}else{
		$('#login-button').html(`<a href="${rootApp}home/login" class="text-black"><small>Login Akun</small></a>`);
	}
}

function logoutFunction(){
    setCookie(appShortName+'MAIN_LOGIN_STATUS', 0, 1)
    setCookie(appShortName+'MAIN_USER_ID', '', 1)
    setCookie(appShortName+'MAIN_fullname', '', 1)
    setCookie(appShortName+'MAIN_level', '', 1)
    setCookie(appShortName+'MAIN_ID_CARD', '', 1)
    setCookie(appShortName+'MAIN_PHONE_NUMBER', '', 1)
    setCookie(appShortName+'MAIN_EMAIL', '', 1)
    setCookie(appShortName+'MAIN_PHOTO', '', 1)
    alert('Anda telah keluar!!')
    window.location.href = rootApp;
}