//On Load Page
$(document).ready(function () {
    if(levelAgen == 'agen'){
        loadPageMyProperty(1)
    }
});

//Get data
function viewAllHome(page = 1) {
    $.ajax({
        url: rootApp + "api/property/by-agent/"+page,
        type: "GET",
        data: {
            agent_name : agentName
        },
        dataType: "json",
        success: function (res) {
            //Render data to view
            __renderMyProperty(res.data)

            //Create link page
            total_rows = res.total
            const linkCollection = createLinkMyProperty(res.page, res.total, res.per_page)
            $('#paging-collection').html(linkCollection)
            $('.showing-rows').html(`Ditampilkan ${res.showing} dari total ${res.total} Properti`)
            $('#content-title').html('Semua daftar properti saya')
        },
        error: function (request, error) {
            // console.log("Request: " + JSON.stringify(request));
        },
    });
}

//Render view list
function __renderMyProperty(data) {
    const levelAgen = getCookie(appShortName + 'MAIN_level') || '';
    const agentName = getCookie(appShortName + 'MAIN_fullname') || '';

    let listData = ``;

    $.each(data, function (index, key) {
        // Tambahan info hanya untuk properti agen sendiri
        let additionalInfo = `<p><i class="fa fa-money mr-1"></i>${key.fee}%</p>`;
        additionalInfo += `<p><i class="fa fa-user-secret mr-1"></i>Owner : ${key.owner_name}</p>`;

        const address = `<p class="mt-1 text-teal-400">
            <small> [${key.unit_number} | ${key.area_name} | ${key.city_name}] </small>
        </p>`;

        // STATUS SALE
        let saleClass = '';
        let sale_type_label = '';

        if (key.sale_status == 1) {
            sale_type_label = key.sale_type == "Sewa" ? 'Disewa' : 'Terjual';
            saleClass = 'bg-sale-terjual';
        } else {
            if (key.sale_type == "Sewa") {
                sale_type_label = 'Sewa';
                saleClass = 'bg-sale-sewa';
            } else {
                sale_type_label = 'Jual';
                saleClass = 'bg-sale-jual';
            }
        }

        listData += `
        <div class="col-md-6 col-lg-4 mb-4 mt-3" data-aos="fade-up">
            <div class="card shadow-sm border-1 rounded-lg">
                <div class="property-image position-relative ${saleClass}">
                    <div class="px-3 pt-2">
                        <div class="row no-gutters">
                            <div class="col-6">
                                <span class="badge badge-pill badge-sale-type text-uppercase">
                                    <i class="fas fa-tag mr-1"></i> ${sale_type_label}
                                </span>
                            </div>
                            <div class="col-6 text-right">
                                <span class="badge badge-pill badge-category text-capitalize">
                                    <i class="fas fa-building mr-1"></i> ${key.asset_category_name}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="p-3">
                    <h5 class="card-title font-weight-bold text-dark">${key.property_title}</h5>
                    <p class="text-muted mb-3"><i class="fas fa-map-marker-alt mr-1"></i> ${key.address}</p>

                    <div class="row text-center mb-3">
                        <div class="col-6">
                            <div class="info-box bg-light rounded p-2">
                                <i class="fas fa-bed text-primary"></i>
                                <div><strong>${key.bedroom}</strong></div>
                                <small class="text-muted">Kamar Tidur</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="info-box bg-light rounded p-2">
                                <i class="fas fa-bath text-purple"></i>
                                <div><strong>${key.bathroom}</strong></div>
                                <small class="text-muted">Kamar Mandi</small>
                            </div>
                        </div>
                    </div>

                    <div class="media mb-3">
                        <div class="rounded-circle agent-icon d-flex align-items-center justify-content-center">
                            <i class="fas fa-user text-white"></i>
                        </div>
                        <div class="media-body ml-2">
                            <h6 class="mb-0 text-dark">${key.agent_name}</h6>
                            ${key.tenant_name ? key.tenant_name : '<span class="text-danger">Cluster belum didaftarkan</span>'}
                        </div>
                    </div>

                    <p class="text-muted mb-2">
                        <i class="fas fa-ruler-combined mr-1"></i>
                        <strong>LT ${numberWithCommas(key.land_area)} m²</strong> | 
                        <strong>LB ${numberWithCommas(key.building_area)} m²</strong>
                    </p>

                    ${address}
                    ${additionalInfo}

                    <h5 class="font-weight-bold text-dark mb-1">Rp ${numberWithCommas(key.price)}</h5>
                    <p class="text-muted">Harga Nego</p>

                    <a href="https://wa.me/${key.agent_phone_number}" target="_blank" class="btn btn-success btn-block font-weight-bold">
                        <i class="fab fa-whatsapp mr-1"></i> Hubungi Agen
                    </a>
                </div>
            </div>
        </div>`;
    });

    $('#property-list').html(listData);
}



//Pagination
var current_page = 1;
var total_rows = 0;

function prevPageMyProperty() {
    if (current_page > 1) {
        current_page--;
        loadPageMyProperty(current_page);
    }
}

function nexPageMyProperty() {
    if (current_page < total_rows) {
        current_page++;
        loadPageMyProperty(current_page);
    }
}

function loadPageMyProperty(page = 1) {
    viewAllHome(page)
}

function createLinkMyProperty(page = 1, totalRows = 1, perPage = 1) {
    var linkCollection = ``
    var numPagesCollection = Math.ceil(totalRows / perPage)

    //Push Previous button
    if (page != 1) {
        linkCollection += `<li><a href="javascript:prevPageMyProperty()" id="btn_prev" class="Previous"><i class="fa fa-chevron-left"></i> Sebelumnya</a></li>`
    } else {
        linkCollection += `<li><a href="javascript:void(0)" id="btn_prev" class="text-secondary"><i class="fa fa-chevron-left"></i> Sebelumnya</a></li>`
    }

    //Push target page link when the value is less than current page
    var min = 1;
    for (var i = page - 3; i <= page; i++) {
        if (i >= 1 && i != page) {
            // linkCollection += `<a href="javascript:loadPageMyProperty(${i})" id="btn_prev">${i}</a>`
            linkCollection += `<li><a href="javascript:loadPageMyProperty(${i})"">${i}</a></li>`
        }
    }

    //Push target page link for the current page
    linkCollection += `<li class="active"><a href="javascript:loadPageMyProperty(${page})"">${page}</a></li>`

    //Push target page link when the value is more than current page
    var min = 1;
    for (var i = page; i <= parseInt(page) + 2; i++) {
        if (i <= numPagesCollection && i != page) {
            linkCollection += `<li><a href="javascript:loadPageMyProperty(${i})"">${i}</a></li>`
        }
    }

    //Push Next button
    if (page != numPagesCollection) {
        linkCollection += `<li><a href="javascript:nexPageMyProperty()" id="btn_next" class="Next"> Next <i class="fa fa-chevron-right"></i></a></li>`
    } else {
        linkCollection += `<li><a href="javascript:void(0)" id="btn_next" class="text-secondary"> Next <i class="fa fa-chevron-right"></i></a></li>`
    }

    return linkCollection
}