import { viewAllTenant } from "./initTenant.js";

export function initAction() {
	/*******************************************************************************************
								VALIDASI INPUT DATA TENANT (TAMBAH)
	*******************************************************************************************/
	$("form[name='add-tenant']").validate({
		rules: {
			tenant_code: "required",
			tenant_name: "required",
		},
		messages: {
			tenant_code: "Kode tenant harus diisi",
			tenant_name: "Nama tenant harus diisi",
		},
		submitHandler: function (form) {
			const formData = new FormData(form);
			$.ajax({
				url: rootApp + "api/tenant/add",
				type: "POST",
				data: formData,
				dataType: "json",
				contentType: false,
				processData: false,
				success: function (res) {
					$("#modal_form_add").modal("hide");
					pnotifySuccess(res.status, res.message);
					$("form[name='add-tenant']")[0].reset();
					viewAllTenant();
				},
				error: function (request, error) {
					pnotifyError("Error", JSON.stringify(request.statusText));
				},
			});
		},
	});

	/*******************************************************************************************
								EDIT TENANT
	*******************************************************************************************/
	$("#table-body-tenant").on("click", ".btn-edit", function () {
		const id = $(this).data("id");
		$.ajax({
			url: rootApp + "api/tenant/get_by_id",
			type: "GET",
			data: { id: id },
			dataType: "json",
			success: function (res) {
				const data = res.data;
				$("#modal_form_edit").modal("show");

				$("#tenant_id").val(data.tenant_id);
				$("#tenant_code").val(data.tenant_code);
				$("#tenant_name").val(data.tenant_name);
				$("#tenant_type").val(data.tenant_type);
				$("#industry").val(data.industry);
				$("#website").val(data.website);
				$("#tax_number").val(data.tax_number);
				$("#description").val(data.description);
			},
			error: function (request, error) {
				pnotifyError("Error", JSON.stringify(request.statusText));
			},
		});
	});

	/*******************************************************************************************
								VALIDASI FORM EDIT
	*******************************************************************************************/
	$("form[name='edit-tenant']").validate({
		rules: {
			tenant_code: "required",
			tenant_name: "required",
		},
		messages: {
			tenant_code: "Kode tenant harus diisi",
			tenant_name: "Nama tenant harus diisi",
		},
		submitHandler: function (form) {
			$.ajax({
				url: rootApp + "api/tenant/edit",
				type: "POST",
				data: $("#edit-tenant").serialize(),
				dataType: "json",
				success: function (res) {
					$("#modal_form_edit").modal("hide");
					pnotifySuccess(res.status, res.message);
					viewAllTenant();
				},
				error: function (request, error) {
					pnotifyError("Error", JSON.stringify(request.statusText));
				},
			});
		},
	});

	/*******************************************************************************************
								DELETE TENANT
	*******************************************************************************************/
	$("#table-body-tenant").on("click", ".btn-delete", function () {
		const id = $(this).data("id");

		if (!confirm("Yakin ingin menghapus tenant ini?")) return;

		$.ajax({
			url: rootApp + "api/tenant/delete",
			type: "POST",
			data: { tenant_id: id },
			dataType: "json",
			success: function (res) {
				pnotifySuccess(res.status, res.message);
				viewAllTenant();
			},
			error: function (request, error) {
				pnotifyError("Error", JSON.stringify(request.statusText));
			},
		});
	});

}
