/*****************************************************************/
/*                      FILTER PROPERTY                         */
/***************************************************************/
$("#form-filter").submit(function(e) {
    e.preventDefault();
    filterPage(1)
});

function filterProperty(page = 1) {
    const agentName = getCookie(appShortName + 'MAIN_fullname') || '';
    const baseData = $("#form-filter").serialize();

    const isMyPropertyPage = window.location.href.includes("my-property");
    const isSaleTypePage = window.location.href.includes("sale-type");

    //Ambil forminput search jika terdapat value
    const search = $('#form-search-input').val();
    console.log(' ini'+search)

    // Ambil nilai sale_type dari URL jika ada
    let saleTypeFromURL = '';
    if (isSaleTypePage) {
        const parts = window.location.href.split('/');
        const index = parts.indexOf('sale-type');
        if (index !== -1 && parts.length > index + 1) {
            const rawType = parts[index + 1].toLowerCase();
            if (rawType === 'rent') {
                saleTypeFromURL = 'Sewa';
            } else if (rawType === 'sale') {
                saleTypeFromURL = 'Jual';
            }
        }
    }

    // Gabungkan data sesuai kondisi
    let requestData = baseData;

    if (search) {
        requestData += `&keywords=${encodeURIComponent(search)}`;
    }
    if (isMyPropertyPage) {
        requestData += `&agent_name=${encodeURIComponent(agentName)}`;
    }
    
    if (isSaleTypePage && saleTypeFromURL !== '') {
        requestData += `&sale_type=${encodeURIComponent(saleTypeFromURL)}`;
    }

    // Kirim AJAX request
    $.ajax({
        url: rootApp + "api/filter/property/" + page,
        type: "POST",
        data: requestData,
        success: function (res) {
            __renderDataFilter(res.data);
            console.log("Data loaded");

            const linkCollection = createLink(res.page, res.total, res.per_page);
            $('#paging-collection').html(linkCollection);
            $('.showing-rows').html(`Ditampilkan ${res.showing} dari total ${res.total} Properti`);
            $('#content-title').html('Semua daftar properti');
        },
        error: function (request, error) {
            console.error("AJAX Error:", error);
        },
    });
}



//Pagination
var current_page = 1;
var total_rows = 0;

function prevPageFilter() {
    if (current_page > 1) {
        current_page--;
        filterPage(current_page);
    }
}

function nextPageFilter() {
    if (current_page < total_rows) {
        current_page++;
        filterPage(current_page);
    }
}

function filterPage(page = 1) {
    filterProperty(page)
}

function createLink(page = 1, totalRows = 1, perPage = 1) {
    var linkCollection = ``
    var numPagesCollection = Math.ceil(totalRows / perPage)

    //Push Previous button
    if (page != 1) {
        linkCollection += `<li><a href="javascript:prevPageFilter()" id="btn_prev" class="Previous"><i class="fa fa-chevron-left"></i> Sebelumnya</a></li>`
    } else {
        linkCollection += `<li><a href="javascript:void(0)" id="btn_prev" class="text-secondary"><i class="fa fa-chevron-left"></i> Sebelumnya</a></li>`
    }

    //Push target page link when the value is less than current page
    var min = 1;
    for (var i = page - 3; i <= page; i++) {
        if (i >= 1 && i != page) {
            // linkCollection += `<a href="javascript:filterPage(${i})" id="btn_prev">${i}</a>`
            linkCollection += `<li><a href="javascript:filterPage(${i})"">${i}</a></li>`
        }
    }

    //Push target page link for the current page
    linkCollection += `<li class="active"><a href="javascript:filterPage(${page})"">${page}</a></li>`

    //Push target page link when the value is more than current page
    var min = 1;
    for (var i = page; i <= parseInt(page) + 2; i++) {
        if (i <= numPagesCollection && i != page) {
            linkCollection += `<li><a href="javascript:filterPage(${i})"">${i}</a></li>`
        }
    }

    //Push Next button
    if (page != numPagesCollection) {
        linkCollection += `<li><a href="javascript:nextPageFilter()" id="btn_next" class="Next"> Next <i class="fa fa-chevron-right"></i></a></li>`
    } else {
        linkCollection += `<li><a href="javascript:void(0)" id="btn_next" class="text-secondary"> Next <i class="fa fa-chevron-right"></i></a></li>`
    }

    return linkCollection
}