//Render view list
function __renderData(data) {
  //CHECK HAVE LOGGED IN YET? ONLY AGEN WILL HAVE VALUE
  const levelAgen = getCookie(appShortName + 'MAIN_level') != '' ? getCookie(appShortName + 'MAIN_level') : '';
  const agentName = getCookie(appShortName + 'MAIN_fullname') != '' ? getCookie(appShortName + 'MAIN_fullname') : '';

  var listData = ``;
  $.each(data, function (index, key) {
    let additionalInfo = `<p><i class="fa fa-money mr-1"></i>${key.fee}%</p>`;

    let address = `<br>`
    if (levelAgen == 'agen' && key.agent_name == agentName) {
      address = `<p class="mt-1 text-teal-400">
                            <small> [${key.unit_number} | ${key.area_name} | ${key.city_name}] </small>
                        </p>`

      additionalInfo += `
			<p><i class="fa fa-user-secret mr-1"></i>Owner : ${key.owner_name}</p>`;
    }
    /******************************* TERSEWAA / TERJUAL ************************************************/
    let saleClass = '';
    let sale_type_label = '';

    if (key.sale_status == 1) {
      // Terjual / Disewa
      sale_type_label = key.sale_type == "Sewa" ? 'Disewa' : 'Terjual';
      saleClass = 'bg-sale-terjual'; // bisa juga bg-sale-disewa, tapi warna sama
    } else {
      if (key.sale_type == "Sewa") {
        sale_type_label = 'Sewa';
        saleClass = 'bg-sale-sewa';
      } else {
        sale_type_label = 'Jual';
        saleClass = 'bg-sale-jual';
      }
    }

    listData += 
    `<div class="col-md-6 col-lg-4 mb-4 mt-3" data-aos="fade-up">
      <div class="card shadow-sm border-1 rounded-lg">
        <div class="property-image position-relative ${saleClass}">
          <div class="px-3 pt-2">
            <div class="row no-gutters">
              <div class="col-6">
                <span class="badge badge-pill badge-sale-type text-uppercase">
                  <i class="fas fa-tag mr-1"></i> ${sale_type_label}
                </span>
              </div>
              <div class="col-6 text-right">
                <span class="badge badge-pill badge-category text-capitalize">
                  <i class="fas fa-building mr-1"></i> ${key.asset_category_name}
                </span>
              </div>
            </div>
          </div>
        </div>

    <div class="p-3">
      <h5 class="card-title font-weight-bold text-dark">${key.property_title}</h5>
      <p class="text-muted mb-3"><i class="fas fa-map-marker-alt mr-1"></i> ${key.address}</p>

      <div class="row text-center mb-3">
        <div class="col-6">
          <div class="info-box bg-light rounded p-2">
            <i class="fas fa-bed text-primary"></i>
            <div><strong>${key.bedroom}</strong></div>
            <small class="text-muted">Kamar Tidur</small>
          </div>
        </div>
        <div class="col-6">
          <div class="info-box bg-light rounded p-2">
            <i class="fas fa-bath text-purple"></i>
            <div><strong>${key.bathroom}</strong></div>
            <small class="text-muted">Kamar Mandi</small>
          </div>
        </div>
      </div>

      <div class="media mb-3">
        <div class="rounded-circle agent-icon d-flex align-items-center justify-content-center">
          <i class="fas fa-user text-white"></i>
        </div>
        <div class="media-body ml-2">
          <h6 class="mb-0 text-dark">${key.agent_name}</h6>
          ${key.tenant_name ? key.tenant_name : '<span class="text-danger">Cluster belum didaftarkan</span>'}
        </div>
      </div>

      <p class="text-muted mb-2"><i class="fas fa-ruler-combined mr-1"></i>
        <strong>LT ${numberWithCommas(key.land_area)} m²</strong> | 
        <strong>LB ${numberWithCommas(key.building_area)} m²</strong>
      </p>

      ${additionalInfo}

      <h5 class="font-weight-bold text-dark mb-1">Rp ${numberWithCommas(key.price)}</h5>
      <p class="text-muted">Harga Nego</p>

      <a href="https://wa.me/${key.agent_phone_number}" target="_blank" class="btn btn-success btn-block font-weight-bold">
        <i class="fab fa-whatsapp mr-1"></i> Hubungi Agen
      </a>
    </div>
  </div>
</div>`;

  })
  $('#property-list').html(listData)
}


//Render view list
function __renderDataFilter(data) {
  const levelAgen = getCookie(appShortName + 'MAIN_level') || '';
  const agentName = getCookie(appShortName + 'MAIN_fullname') || '';

  let listData = ``;

  $.each(data, function (index, key) {
    // Default info
    let additionalInfo = `<p><i class="fa fa-money mr-1"></i>${key.fee}%</p>`;
    let address = `<br>`;

    // Jika user adalah agen dan nama sesuai, tampilkan info tambahan
    if (levelAgen == 'agen' && key.agent_name == agentName) {
      address = `<p class="mt-1 text-teal-400">
                  <small> [${key.unit_number} | ${key.area_name} | ${key.city_name}] </small>
                </p>`;
      additionalInfo += `<p><i class="fa fa-user-secret mr-1"></i>Owner : ${key.owner_name}</p>`;
    }

    // Status properti
    let saleClass = '';
    let sale_type_label = '';

    if (key.sale_status == 1) {
      sale_type_label = key.sale_type == "Sewa" ? 'Disewa' : 'Terjual';
      saleClass = 'bg-sale-terjual';
    } else {
      sale_type_label = key.sale_type == "Sewa" ? 'Sewa' : 'Jual';
      saleClass = key.sale_type == "Sewa" ? 'bg-sale-sewa' : 'bg-sale-jual';
    }

    listData += `
    <div class="col-md-6 col-lg-4 mb-4 mt-3" data-aos="fade-up">
      <div class="card shadow-sm border-1 rounded-lg">
        <div class="property-image position-relative ${saleClass}">
          <div class="px-3 pt-2">
            <div class="row no-gutters">
              <div class="col-6">
                <span class="badge badge-pill badge-sale-type text-uppercase">
                  <i class="fas fa-tag mr-1"></i> ${sale_type_label}
                </span>
              </div>
              <div class="col-6 text-right">
                <span class="badge badge-pill badge-category text-capitalize">
                  <i class="fas fa-building mr-1"></i> ${key.asset_category_name}
                </span>
              </div>
            </div>
          </div>
        </div>

        <div class="p-3">
          <h5 class="card-title font-weight-bold text-dark">${key.property_title}</h5>
          <p class="text-muted mb-3"><i class="fas fa-map-marker-alt mr-1"></i> ${key.address}</p>

          <div class="row text-center mb-3">
            <div class="col-6">
              <div class="info-box bg-light rounded p-2">
                <i class="fas fa-bed text-primary"></i>
                <div><strong>${key.bedroom}</strong></div>
                <small class="text-muted">Kamar Tidur</small>
              </div>
            </div>
            <div class="col-6">
              <div class="info-box bg-light rounded p-2">
                <i class="fas fa-bath text-purple"></i>
                <div><strong>${key.bathroom}</strong></div>
                <small class="text-muted">Kamar Mandi</small>
              </div>
            </div>
          </div>

          <div class="media mb-3">
            <div class="rounded-circle agent-icon d-flex align-items-center justify-content-center">
              <i class="fas fa-user text-white"></i>
            </div>
            <div class="media-body ml-2">
              <h6 class="mb-0 text-dark">${key.agent_name}</h6>
              ${key.tenant_name ? key.tenant_name : '<span class="text-danger">Cluster belum didaftarkan</span>'}
            </div>
          </div>

          <p class="text-muted mb-2">
            <i class="fas fa-ruler-combined mr-1"></i>
            <strong>LT ${numberWithCommas(key.land_area)} m²</strong> | 
            <strong>LB ${numberWithCommas(key.building_area)} m²</strong>
          </p>

          ${address}
          ${additionalInfo}

          <h5 class="font-weight-bold text-dark mb-1">Rp ${numberWithCommas(key.price)}</h5>
          <p class="text-muted">Harga Nego</p>

          <a href="https://wa.me/${key.agent_phone_number}" target="_blank" class="btn btn-success btn-block font-weight-bold">
            <i class="fab fa-whatsapp mr-1"></i> Hubungi Agen
          </a>
        </div>
      </div>
    </div>`;
  });

  $('#property-list').html(listData);
}
